

#ifndef __jabber_meeting_account_cup_sync_h__
#define __jabber_meeting_account_cup_sync_h__

#include "JabberMeetingAccountSync.h"

namespace CSFUnified
{
    class JabberMeetingAccountCupSync : public IJabberMeetingAccountSync
    {
    public:
        JabberMeetingAccountCupSync(IJabberMeetingAccountEvent * pEvent);
        virtual ~JabberMeetingAccountCupSync();
        
        virtual void start();
        virtual void stop();
        virtual void syncAllSite();
        virtual void getDefaultSite();
        virtual void setDefaultSite(SMART_PTR_NS::shared_ptr<MeetingSiteImpl> site, std::string sessionTicket, long keepAliveTime);
        virtual void deleteSite(std::string siteUrl);
        virtual void updateAllSite(std::string defaultSiteUrl, MeetingSiteImpl* addedSite, std::string deletedSiteUrl);
        
    private:
        void reset();
        void loadServerSite(std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >& siteList);
        void loadLocalSite(std::list<SMART_PTR_NS::shared_ptr<MeetingSiteImpl> >& siteList, std::string& defaultSite);
		void addSiteToList(std::string siteUrl);
		void delSiteFromList(std::string siteUrl);
		void saveSiteInfomation(MeetingSiteImpl *pObj);
        
    private:
        IJabberMeetingAccountEvent& m_event;
        SMART_PTR_NS::shared_ptr<MeetingSiteImpl> m_defaultSite;
        SMART_PTR_NS::shared_ptr<MeetingSiteImpl> m_locatSite;
        SMART_PTR_NS::shared_ptr<MeetingSiteImpl> m_locatSite_backup;
        SMART_PTR_NS::shared_ptr<MeetingSiteImpl> m_locatSite_backup2;
        std::list<std::string> m_localSiteList;
    };
}

#endif//__jabber_meeting_account_cup_sync_h__
